<x-app-layout>
    <x-slot name="header">
        Bookings
    </x-slot>

    <div class="row row-sm">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <a href="{{ route('package') }}" class="btn btn-primary">Add New</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered text-nowrap border-bottom">
                            <thead>
                                <tr>
                                    <th class="border-bottom-0">Booking ID</th>
                                    <th class="border-bottom-0">Package</th>
                                    <th class="border-bottom-0">Paid Amount</th>
                                    <th class="border-bottom-0">Total Travelers</th>
                                    <th class="border-bottom-0">Tour Date</th>
                                    <th class="border-bottom-0">Status</th>
                                    <th class="border-bottom-0">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($bookings as $booking)
                                <tr>
                                    <td>
                                        <a href="{{ route('user.booking.show', $booking->id) }}">{{ $booking->trnx_id }}</a>
                                    </td>
                                    <td>{{ word_limit($booking->package->name, 5) }}</td>
                                    <td>{{ number_format($booking->amount, 2) }}/{{ number_format($booking->amount_paid, 2) }}</td>
                                    <td>{{ $booking->peoples }}</td>
                                    <td>{{ $booking->package->start_date->format('d M Y') }}</td>
                                    <td>
                                        @if ($booking->status == 'pending')
                                            <span class="badge bg-warning">Pending</span>
                                        @elseif ($booking->status == 'approved')
                                            <span class="badge bg-success">Approved</span>
                                        @elseif ($booking->status == 'rejected')
                                            <span class="badge bg-danger">Rejected</span>
                                        @elseif ($booking->status == 'completed')
                                            <span class="badge bg-info">Completed</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('user.booking.show', $booking->id) }}"
                                            class="btn btn-primary btn-sm">Details</a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <x-slot name="script">
        <x-datatable-js />
        <x-confirm-js />
    </x-slot>
</x-app-layout>
